﻿using System;
using System.Drawing;

namespace Tutor_RT
{
    public class Color_0_to_1
    {
        public double special, red, green, blue;
        //special is for superpositions;
        //my color + color from surrounding; reflection, ...
        #region Constructors

        public Color_0_to_1()
        {
            special = 0;
            red = 0;
            green = 0;
            blue = 0;           
        }

        public Color_0_to_1(double s, double r, double g, double b)
        {
            special = s;
            red = r;
            green = g;
            blue = b;           
        }

        public Color_0_to_1(double s, Color col)
        {
            special = s;
            red = col.R / 255.0;
            green = col.G / 255.0;
            blue = col.B / 255.0;
        }

        #endregion

        public double C01_S {
            get { return special; }
            set { special = value; }
        }
        public double C01_R {
            get { return red; }
            set { red = value; }
        }
        public double C01_G {
            get { return green; }
            set { green = value; }
        }
        public double C01_B {
            get { return blue; }
            set { blue = value; }
        }
        
        public double brightness()
        {
            return (red + green + blue) / 3.0;
        }

        public static Color_0_to_1 operator *(double s, Color_0_to_1 c)
        {
            return new Color_0_to_1(s *c.C01_S, s* c.C01_R, s* c.C01_G, s* c.C01_B);
        }

        public static Color_0_to_1 operator +(Color_0_to_1 c1, Color_0_to_1 c2)
        {
            return new Color_0_to_1(c1.C01_S+c2.C01_S, c1.C01_R+c2.C01_R, c1.C01_G+c2.C01_G, c1.C01_B+c2.C01_B);
        }

        public static Color_0_to_1 operator *(Color_0_to_1 c1, Color_0_to_1 c2)
        {
            return new Color_0_to_1(c1.C01_S * c2.C01_S, c1.C01_R * c2.C01_R, c1.C01_G * c2.C01_G, c1.C01_B * c2.C01_B);
        }

        public Color_0_to_1 clip()
        {//distribute a surplus dc
            double rgb_sum = red + green + blue;//rgb_sum = 3 + dc
            double dc = rgb_sum - 3;
            if (dc > 0)
            {
                red = red + dc * (red / rgb_sum);//red-amount from surplus
                green = green + dc * (green / rgb_sum);//green-amount from surplus
                blue = blue + dc * (blue / rgb_sum);//blue-amount from surplus
            }
            red = Math.Max(0, red); red = Math.Min(red, 1);
            green = Math.Max(0, green); green = Math.Min(green, 1);
            blue = Math.Max(0, blue); blue = Math.Min(blue, 1);
            return new Color_0_to_1(special, red, green, blue);
        }

        public Color WinColor()
        {
            return Color.FromArgb(255, (int)Math.Floor(255*red), (int)Math.Floor(255 * green), (int)Math.Floor(255 * blue));
        }
    }
}
