﻿namespace Tutor_RT
{
    public class Plane : AObject
    {
        public V3 normal;//x=a+mue*u+nue*v; <n0,x>-<n0,a>=0=<n0,x>-d_PO
        public double d_PO;//d_PO(plane, A); distance of plane to A
        public Color_0_to_1 color;

        #region Constructors

        public Plane()
        {
            normal = new V3(1,0,0);
            d_PO = 0;
            color = new Color_0_to_1(0,0.5,0.5,0.5);
        }

        public Plane(V3 n, double d, Color_0_to_1 col)
        {
            normal = n.normalize;
            d_PO = d;
            color = col;
        }

        public double get_d_PO //d_PO(plane, A)
        {
            get { return d_PO; }
        }

        public override Color_0_to_1 getColor 
        {
            get { return color; }
        }

        #endregion

        public override V3 get_n(V3 point)    
        {
            return normal;
        }

        public override double Lambda_min(Ray ray)
        {
            double a = ray.get_u * normal;
            if (a == 0) return -1;//b = d_PO * normal 
            else  //r = <n,b-a>/<n,u>, g:x=a+r*u, E:<n,x>-<n,b>=0                
                return normal * (d_PO * normal - ray.get_a) / a;              
        }
    }
}
