﻿namespace Tutor_RT
{
    public class Ray
    {
        public V3 A, u;

        #region Constructors

        public Ray()
        {
            A = new V3();
            u = new V3(0,0,1);
        }

        public Ray(V3 o, V3 d)
        {
            A = o;
            u = d.normalize;
        }

        public V3 get_a    
        {
            get { return A; }
        }

        public V3 get_u    
        {
            get { return u; }
        }


        #endregion

        #region Operators

        public override bool Equals(object obj)
        {
            //return this.Equals(obj as Ray);
            return (A == (obj as Ray).A) && (u == (obj as Ray).u);
        }

        public override int GetHashCode()
        {
            return (A.GetHashCode() * u.GetHashCode() + 1);
        }

        public static bool operator ==(Ray r1, Ray r2)
        {
            return r1.Equals(r2);
        }

        public static bool operator !=(Ray r1, Ray r2)
        {
            return !r1.Equals(r2);
        }

        #endregion

        public override string ToString()
        {
            return string.Format("x = {0} + t * {1}", A.Text(), u.Text());
        }

    }
}
