﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace circular
{
    public partial class Form1 : Form
    {
        private double xmin, xmax, ymin, ymax;
        private double xFactor, yFactor;

        public Form1()
        {
            InitializeComponent();
            xmin = -3; xmax = 3;
            ymin = 0;
        }

        public int xX(double x)
        {
            return (int)Math.Round(xFactor * (x - xmin));
        }

        public int yY(double y)
        {
            return (int)Math.Round(yFactor * (ymax - y));
        }

        public void drawCircle(Graphics g, Color c, int d, double center_x, double center_y, double radius)
        {
            g.DrawEllipse(new Pen(c,d), xX(center_x - radius), yY(center_y + radius), 2 * xX(xmin + radius), 2 * yY(ymax - radius));
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            ymax = (xmax - xmin) * this.ClientRectangle.Height / this.ClientRectangle.Width;
            xFactor = this.ClientRectangle.Width / (xmax - xmin);
            yFactor = this.ClientRectangle.Height / (ymax - ymin);
            Graphics g = e.Graphics;
            g.Clear(Color.Cornsilk);
            Font fn = new Font("Consolas", 14, FontStyle.Italic);
            Brush br = new SolidBrush(Color.Blue);
            g.DrawString(ymax.ToString(), fn, br, 10, 10);
            g.DrawString(xX(xmin).ToString(), fn, br, 10, 40);
            g.DrawString(yY(ymax).ToString(), fn, br, 10, 70);
            g.DrawLine(new Pen(Color.Black, 1), xX(0), yY(xmin), xX(0), yY(ymax));//yAchse
            for(int i = 1; i < ymax; i++)
                g.DrawLine(new Pen(Color.Black, 1), xX(0-0.1), yY(i), xX(0+0.1), yY(i));//yAchse
            drawCircle(g,Color.Red,1,-2,2.5,0.5); drawCircle(g, Color.Green,5, 2, 2.5, 0.5);
            drawCircle(g, Color.Blue,9, - 2, 0.7, 0.5); drawCircle(g, Color.BlueViolet,13, 2, 0.7, 0.5);
        }
    }
}
