package c17.b17.a17.gc;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

public class KB extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.kb);
        EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
        String term = getIntent().getStringExtra("Term");
        t_in.setText(term);
        t_in.setSelection(t_in.getText().length());
    }
    
    public void insert(String txt) {
    	EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
    	int start = Math.max(t_in.getSelectionStart(), 0);
    	int end = Math.max(t_in.getSelectionEnd(), 0);
    	t_in.getText().replace(Math.min(start, end), Math.max(start, end), txt, 0, txt.length());
    }

    public void key_sinh(View v) { insert("sinh("); }

    public void key_asinh(View v) { insert("asinh("); }

    public void key_cosh(View v) { insert("cosh("); }

    public void key_acosh(View v) { insert("acosh("); }

    public void key_tanh(View v) { insert("tanh("); }

    public void key_atanh(View v) { insert("atanh("); }

    public void key_sin(View v) { insert("sin("); }
    
    public void key_asin(View v) { insert("asin("); }
    
    public void key_cos(View v) { insert("cos("); }
    
    public void key_acos(View v) { insert("acos("); }
    
    public void key_tan(View v) { insert("tan("); }
    
    public void key_atan(View v) { insert("atan("); }
    
    public void key_ept(View v) { insert("!"); }       
    
    public void key_sqrt(View v) { insert("sqrt("); }
    
    public void key_caret(View v) { insert("^"); }
    
    public void key_exp(View v) { insert("exp("); }
    
    public void key_ln(View v) { insert("ln("); }
    
    public void key_log(View v) { insert("log("); }
    
    public void key_pi(View v) { insert("pi"); }
    
    public void key_auf(View v) { insert("("); }
    
    public void key_zu(View v) { insert(")"); }
    
    public void key_abs(View v) { insert("abs("); }
    
    public void key_e(View v) { insert("e^1"); }
    
    public void key_div(View v) { insert("/"); }
    
    public void key_7(View v) { insert("7"); }
    
    public void key_8(View v) { insert("8"); }
    
    public void key_9(View v) { insert("9"); }
    
    public void key_clear(View v) {
    	((EditText) findViewById(R.id.id_kb_txt)).setText("");
    }
    
    public void key_del(View v) {
    	EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
    	int n = t_in.getSelectionStart();
        if(0 < n) {
        	t_in.setText(t_in.getText().delete(n - 1, n));
        	t_in.setSelection(n-1);
        }
    }
    
    public void key_mul(View v) { insert("*"); }
    
    public void key_4(View v) { insert("4"); }
    
    public void key_5(View v) { insert("5"); }
    
    public void key_6(View v) { insert("6"); }
    
    public void key_left(View v) {
        EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
        if((t_in.length()>0) && (t_in.getSelectionStart()>0))
        t_in.setSelection(t_in.getSelectionStart() - 1);     
    }
    
    public void key_right(View v) {
    	EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
        if((t_in.length()>0) && (t_in.getSelectionStart()<t_in.length()))
        t_in.setSelection(t_in.getSelectionStart() + 1);        
    }
    
    public void key_minus(View v) { insert("-"); }
    
    public void key_1(View v) { insert("1"); }
    
    public void key_2(View v) { insert("2"); }
    
    public void key_3(View v) { insert("3"); }
    
    public void key_0(View v) { insert("0"); }
    
    public void key_dot(View v) { insert("."); }
    
    public void key_plus(View v) { insert("+"); }
    
    public void key_x(View v) { insert("x"); }
    
    public void key_t(View v) { insert("t"); }
    
    public void key_return(View v) {
    	EditText t_in = (EditText) findViewById(R.id.id_kb_txt);
    	Intent iback = new Intent();
    	iback.putExtra("return", t_in.getText().toString());
    	setResult(Activity.RESULT_OK, iback);
    	finish();       
    }

}

