package c17.b17.a17.gc;

import java.text.DecimalFormat;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.os.Bundle;
import android.view.ViewGroup.LayoutParams;
import android.view.MotionEvent;
import android.support.v4.view.MotionEventCompat;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.View.OnTouchListener;

public class Win2 extends Activity implements OnTouchListener{
	Paint paint = new Paint();   
	Canvas cv;
	double xmin, xmax, ymin, ymax, tmin, tmax, dt;
    double xStreckfaktor, yStreckfaktor;
    String str_f1, str_f2, str_f3, str_f4;
    int screen_w, screen_h;
    boolean two_finger = false, is_touching = false;
    Point f1A0 = new Point(0,0), f1A1 = new Point(0,0), f2B0 = new Point(0,0), f2B1 = new Point(0,0);

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.main2);
        //getWindow().getDecorView().getRootView()
        MyView view = new MyView(this);        
        LayoutParams params = new LayoutParams(LayoutParams.WRAP_CONTENT,LayoutParams.WRAP_CONTENT);
        addContentView(view, params);
        view.setOnTouchListener(this);
        
        String[] trans = new String[11], ts;
        trans[0] = getIntent().getStringExtra("xmin");
        trans[1] = getIntent().getStringExtra("xmax");
        trans[2] = getIntent().getStringExtra("ymin");
        trans[3] = getIntent().getStringExtra("ymax");
        if(trans[0].isEmpty()) trans[0] = "-5";
        if(trans[1].isEmpty()) trans[1] = "5";
        if(trans[2].isEmpty()) trans[2] = "-20";
        if(trans[3].isEmpty()) trans[3] = "20";
        trans[4] = getIntent().getStringExtra("f1_of_x");
        trans[5] = getIntent().getStringExtra("f2_of_x");
        trans[6] = getIntent().getStringExtra("f3_of_x");
        trans[7] = getIntent().getStringExtra("f4_of_x");
        trans[8] = getIntent().getStringExtra("tmin");
        trans[9] = getIntent().getStringExtra("tmax");
        trans[10] = getIntent().getStringExtra("dt");
        if(trans[8].isEmpty()) trans[8] = "1";
        if(trans[9].isEmpty()) trans[9] = "1";
        if(trans[10].isEmpty()) trans[10] = "1";
        
        ts = trans;
        str_f1 = ts[4];
        str_f2 = ts[5];
        str_f3 = ts[6];
        str_f4 = ts[7];
        xmax = Double.valueOf(ts[1]);
        xmin = Double.valueOf(ts[0]);
        ymax = Double.valueOf(ts[3]);
        ymin = Double.valueOf(ts[2]);
        tmin = Double.valueOf(ts[8]);
        tmax = Double.valueOf(ts[9]);
        dt = Double.valueOf(ts[10]);
    }
    
    private class MyView extends View {

        public MyView(Context context) {
            super(context); 
        }
        
        @Override
        public void draw(final Canvas canvas) {
            super.draw(canvas);
        	init(canvas);
        }
        
        private void init(Canvas canvas)	{
    		cv = canvas;
    		cv.drawColor(Color.WHITE);
    		screen_w = cv.getWidth();
    		screen_h = cv.getHeight();
    		xStreckfaktor = cv.getWidth() / (xmax - xmin);
            yStreckfaktor = cv.getHeight() / (ymax - ymin);
            paint.setStrokeWidth(3); 
            if(!str_f1.isEmpty()) ZeichneFktSchar(str_f1);
            if(!str_f2.isEmpty()) ZeichneFkt(str_f2, 2);
            if(!str_f3.isEmpty()) ZeichneFkt(str_f3, 3);
            if(!str_f4.isEmpty()) ZeichneFkt(str_f4, 4);
            coord_sys();
    	}

    }
    
    public boolean onTouch(View v, MotionEvent me) {
        final int action = me.getAction() & MotionEvent.ACTION_MASK, n_f = me.getPointerCount();
        if ((n_f == 2) && (action == MotionEvent.ACTION_POINTER_DOWN)) {//two finger touch event
            f1A0.x = (int) MotionEventCompat.getX(me, 0);//Finger 1 at A0 is start point
            f1A0.y = (int) MotionEventCompat.getY(me, 0);
            f2B0.x = (int) MotionEventCompat.getX(me, 1);//Finger 2 at B0 is start point
            f2B0.y = (int) MotionEventCompat.getY(me, 1);
            two_finger = true;
            is_touching = true;
            v.invalidate();//calls onDraw(...
            return true;
        }

        if (is_touching && ((action == MotionEvent.ACTION_UP) || (action == MotionEvent.ACTION_POINTER_UP))) {//two finger touch event
            f1A1.x = (int) MotionEventCompat.getX(me, 0);//Finger 1 at A1 is end point
            f1A1.y = (int) MotionEventCompat.getY(me, 0);
            f2B1.x = (int) MotionEventCompat.getX(me, 1);//Finger 2 at B1 is end point
            f2B1.y = (int) MotionEventCompat.getY(me, 1);
            new_min_max(f1A0,f2B0,f1A1,f2B1);
            two_finger = true;
            is_touching = false;
            v.invalidate();//calls onDraw(...
            return true;
        }

        return true;

	}

    //Finger_0: f1A0=A0, Finger_1: f2B0=B0, Finger_0: f1A1=A1, Finger_1: f2B1=B1
    public double fct_lambda(Point A0, Point B0, Point A1, Point B1) {
        double dx0 = (double)Math.abs(A0.x-B0.x), dx1 = (double)Math.abs(A1.x-B1.x);
        if((dx0<50) || (dx1<50)) return 1;
        return dx0/dx1;
    }

    public double fct_mue(Point A0, Point B0, Point A1, Point B1) {
        double dy0 = (double)Math.abs(A0.y-B0.y), dy1 = (double)Math.abs(A1.y-B1.y);
        if((dy0<50) || (dy1<50)) return 1;
        return dy0/dy1;
    }

    public double fct_shift_x(Point A0, Point B0, Point A1, Point B1) {
        return 0.5*(A1.x+B1.x-A0.x-B0.x);
    }

    public double fct_shift_y(Point A0, Point B0, Point A1, Point B1) {
        return 0.5*(A1.y+B1.y-A0.y-B0.y);
    }

    public void new_min_max(Point A0, Point B0, Point A1, Point B1) {
        double xi=xmin, xa=xmax, yi=ymin, ya=ymax;//save old values
        xmin = xi * fct_lambda(A0,B0,A1,B1) - (xa - xi)*fct_shift_x(A0,B0,A1,B1)/screen_w;
        xmax = xa * fct_lambda(A0,B0,A1,B1) - (xa - xi)*fct_shift_x(A0,B0,A1,B1)/screen_w;
        ymin = yi * fct_mue(A0, B0, A1, B1) + (ya - yi)*fct_shift_y(A0, B0, A1, B1)/screen_h;
        ymax = ya * fct_mue(A0,B0,A1,B1) + (ya - yi)*fct_shift_y(A0,B0,A1,B1)/screen_h;
    }

    public int xX(double x) {
        return (int)Math.round(xStreckfaktor * (x - xmin));
    }

    public int yY(double y) {
        return (int)Math.round(yStreckfaktor * (ymax - y));
    }
    
    public void ZeichneFkt(String mstr, int i)
    {
        double x, dx;
        int xvon, yvon, xbis, ybis;
        Term fct=new Term(mstr);
        double y, y1;
        boolean draw = true;
        if(i==1) paint.setColor(Color.BLUE);
        else if(i==2) paint.setColor(Color.RED);
        else if(i==3) paint.setColor(Color.GREEN);
        else if(i==4) paint.setColor(Color.rgb(255, 160, 0));
        else if(i==5) paint.setColor(Color.rgb(0, 100, 0));
        else if(i==6) paint.setColor(Color.MAGENTA);
        else if(i==7) paint.setColor(Color.CYAN);
        else if(i==8) paint.setColor(Color.YELLOW);
        else if(i==9) paint.setColor(Color.GRAY);
        else paint.setColor(Color.BLACK);
        dx = (xmax - xmin) / cv.getWidth()/2;
        x = xmin; y=fct.value_of_math_expr(x, 1);
        xvon = xX(x); yvon = yY(y);  
        x += dx;
        while (x <= xmax)
        {
        	y1=fct.value_of_math_expr(x, 1);
        	if(y1 < ymin) y1 = 1.1*ymin;
        	if(ymax<y1) y1 = 1.1*ymax;
        	xbis = xX(x); ybis = yY(y1);
        	if(((y<ymin)&(ymax<y1))||((y1<ymin)&(ymax<y))) draw = false;
        	if(((y<ymin)&(y1<ymin))||((ymax<y1)&(ymax<y))) draw = false;
        	if(draw) cv.drawLine(xvon, yvon, xbis, ybis, paint);
            x += dx; xvon = xbis; yvon = ybis; y = y1; draw = true;
        }
    }
    
    public void ZeichneFktSchar(String mstr)
    {
        double x, dx;
        int xvon, yvon, xbis, ybis, i=0;
        Term fct=new Term(mstr);
        double y, y1, t;
        boolean draw = true;
        t = tmin;
        while (t <= tmax){
        if(i==0) paint.setColor(Color.BLUE);
        else if(i==1) paint.setColor(Color.rgb(100, 0, 0));
        else if(i==2) paint.setColor(Color.GREEN);
        else if(i==3) paint.setColor(Color.rgb(0, 100, 0));
        else if(i==4) paint.setColor(Color.rgb(255, 105, 0));
        else if(i==5) paint.setColor(Color.MAGENTA);
        else if(i==6) paint.setColor(Color.CYAN);
        else if(i==7) paint.setColor(Color.YELLOW);
        else if(i==8) paint.setColor(Color.GRAY);
        else paint.setColor(Color.BLACK);
        dx = (xmax - xmin) / cv.getWidth()/2;
        x = xmin; y=fct.value_of_math_expr(x, t); 
        xvon = xX(x); yvon = yY(y);
        x += dx;
        while (x <= xmax)
        {
        	y1=fct.value_of_math_expr(x, t);
        	if(y1 < ymin) y1 = 1.1*ymin;
        	if(ymax<y1) y1 = 1.1*ymax;
        	xbis = xX(x); ybis = yY(y1);
        	if(((y<ymin)&(ymax<y1))||((y1<ymin)&(ymax<y))) draw = false;
        	if(((y<ymin)&(y1<ymin))||((ymax<y1)&(ymax<y))) draw = false;
        	if(draw) cv.drawLine(xvon, yvon, xbis, ybis, paint);
            x += dx; xvon = xbis; yvon = ybis; y = y1; draw = true;
        }
        t = t + dt; i=(i+1)%10;
        }
    }
    
    void coord_sys()
    {
    	paint.setStrokeWidth(2);
    	paint.setColor(Color.LTGRAY);
        cv.drawLine(xX(xmin),yY(0),xX(xmax),yY(0), paint);//x_achse
        cv.drawLine(xX(0),yY(ymin),xX(0),yY(ymax), paint);//y_achse
        DecimalFormat nf = new DecimalFormat("0.0");
        paint.setColor(Color.BLACK); 
    	paint.setTextSize(25);
    	String txt = nf.format(xmax);
    	cv.drawText(txt, xX(xmax)-txt.length()*12, yY(0), paint);
    	txt = nf.format(xmin);
    	cv.drawText(txt, xX(xmin), yY(0), paint);
    	txt = nf.format(ymax);
    	cv.drawText(txt, xX(0), yY(ymax)+20, paint);
    	txt = nf.format(ymin);
    	cv.drawText(txt, xX(0), yY(ymin), paint);
    }
    
    //@Override
    public void onBackPressed() {
        xmin = Math.round( xmin * 1000 ) / 1000.;//three decimal places after decimal point
        xmax = Math.round( xmax * 1000 ) / 1000.;
        ymin = Math.round( ymin * 1000 ) / 1000.;
        ymax = Math.round( ymax * 1000 ) / 1000.;
    	Intent iback = new Intent();
    	iback.putExtra("r_xmin", Double.toString(xmin));
    	iback.putExtra("r_xmax", Double.toString(xmax));
    	iback.putExtra("r_ymin", Double.toString(ymin));
    	iback.putExtra("r_ymax", Double.toString(ymax));
    	setResult(Activity.RESULT_OK, iback);
    	finish(); 
    }

}
